<?php
defined('_JEXEC') or die;

return [

  'transforms' => [

    // Prevent rendering if everything is effectively empty (collapsing layout)
    'render' => function ($node) {

      $p = (array) ($node->props ?? []);

      $height = (float) ($p['height_value'] ?? 0);
      $bg     = trim((string) ($p['background'] ?? ''));

      $hasShape =
          !empty($p['top_enable']) ||
          !empty($p['bottom_enable']);

      // Render if any divider is enabled or a background or height is set
      return (bool) ($hasShape || $bg !== '' || $height > 0);
    },

  ],

];
